#include "lpc8xx.h"

static volatile uint32_t st_count = 0;

void SysTick_Handler(void)
{
    st_count++;
}

void SysTick_Init()
{
	SysTick_Config(SystemCoreClock / 1000);        // produce a timer interrupt every 1ms
}

void SysTick_delay_ms(uint32_t ms)
{
  volatile uint32_t until = st_count + ms;

    while (until > st_count)
        __WFI();                                   // Enter sleep mode
}
